/*
 * Decompiled with CFR 0.152.
 */
package rearth.oracle.util;

import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.ItemComponent;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.component.TextureComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.container.GridLayout;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.OwoUIDrawContext;
import io.wispforest.owo.ui.core.PositionedRectangle;
import io.wispforest.owo.ui.core.Positioning;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.core.VerticalAlignment;
import io.wispforest.owo.ui.util.NinePatchTexture;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_1011;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_7923;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import rearth.oracle.ui.components.ScalableLabelComponent;

public class MarkdownParser {
    private static final String[] removedLines = new String[]{"<center", "</center", "<div", "</div", "<span", "</span", "---"};
    public static final class_2960 ITEM_SLOT = class_2960.method_60655((String)"oracle_index", (String)"textures/item_cell.png");
    public static Surface ORACLE_PANEL = (context, component) -> NinePatchTexture.draw((class_2960)class_2960.method_60655((String)"oracle_index", (String)"bedrock_panel"), (OwoUIDrawContext)context, (PositionedRectangle)component);
    public static Surface ORACLE_PANEL_HOVER = (context, component) -> NinePatchTexture.draw((class_2960)class_2960.method_60655((String)"oracle_index", (String)"bedrock_panel_hover"), (OwoUIDrawContext)context, (PositionedRectangle)component);
    public static Surface ORACLE_PANEL_PRESSED = (context, component) -> NinePatchTexture.draw((class_2960)class_2960.method_60655((String)"oracle_index", (String)"bedrock_panel_pressed"), (OwoUIDrawContext)context, (PositionedRectangle)component);
    public static Surface ORACLE_PANEL_DARK = (context, component) -> NinePatchTexture.draw((class_2960)class_2960.method_60655((String)"oracle_index", (String)"bedrock_panel_dark"), (OwoUIDrawContext)context, (PositionedRectangle)component);

    public static List<Component> parseMarkdownToOwoComponents(String markdown, String bookId, Predicate<String> linkHandler) {
        ArrayList<Component> components = new ArrayList<Component>();
        Map<String, String> frontMatter = MarkdownParser.parseFrontmatter(markdown);
        String contentWithoutFrontmatter = MarkdownParser.removeFrontmatter(markdown);
        FlowLayout spacedPanel = MarkdownParser.getTitlePanel(linkHandler, frontMatter);
        components.add((Component)spacedPanel);
        List<String> paragraphs = MarkdownParser.splitIntoParagraphs(contentWithoutFrontmatter);
        Pattern htmlTagPattern = Pattern.compile("<([a-zA-Z0-9]+)(?:\\s[^>]*)?>");
        for (String paragraph : paragraphs) {
            String trimmedParagraph = paragraph.trim();
            if (trimmedParagraph.isEmpty()) continue;
            Matcher matcher = htmlTagPattern.matcher(trimmedParagraph);
            if (matcher.lookingAt()) {
                String tagName = matcher.group(1);
                if ("Callout".equalsIgnoreCase(tagName)) {
                    components.add(MarkdownParser.parseCalloutParagraph(paragraph, linkHandler));
                    continue;
                }
                if ("ModAsset".equalsIgnoreCase(tagName)) {
                    components.add(MarkdownParser.parseImageParagraph(paragraph, bookId, true));
                    continue;
                }
                if ("Asset".equalsIgnoreCase(tagName)) {
                    components.add(MarkdownParser.parseImageParagraph(paragraph, bookId, false));
                    continue;
                }
                if (!"CraftingRecipe".equalsIgnoreCase(tagName)) continue;
                components.add(MarkdownParser.parseRecipeParagraph(paragraph));
                continue;
            }
            components.add(MarkdownParser.parseParagraphToLabel(trimmedParagraph, linkHandler));
        }
        return components;
    }

    private static FlowLayout getTitlePanel(Predicate<String> linkHandler, Map<String, String> frontMatter) {
        FlowLayout combinedPanel = Containers.horizontalFlow((Sizing)Sizing.fill(), (Sizing)Sizing.content());
        combinedPanel.margins(Insets.of((int)2, (int)10, (int)0, (int)0));
        FlowLayout titlePanel = Containers.horizontalFlow((Sizing)Sizing.content((int)0), (Sizing)Sizing.content((int)0));
        titlePanel.padding(Insets.of((int)10, (int)10, (int)10, (int)10));
        titlePanel.surface(ORACLE_PANEL);
        combinedPanel.child((Component)titlePanel.positioning(Positioning.absolute((int)54, (int)7)));
        String title = frontMatter.getOrDefault("title", "Title not found in Frontmatter");
        String iconId = frontMatter.getOrDefault("icon", "");
        if (!iconId.isEmpty()) {
            if (class_7923.field_41178.method_10250(class_2960.method_60654((String)iconId))) {
                class_1799 itemDisplay = new class_1799((class_1935)class_7923.field_41178.method_10223(class_2960.method_60654((String)iconId)));
                ItemComponent itemComponent = Components.item((class_1799)itemDisplay);
                itemComponent.sizing(Sizing.fixed((int)48));
                FlowLayout itemPanel = Containers.horizontalFlow((Sizing)Sizing.content((int)0), (Sizing)Sizing.content((int)0));
                itemPanel.padding(Insets.of((int)6, (int)6, (int)6, (int)6));
                itemPanel.surface(ORACLE_PANEL);
                itemPanel.child((Component)itemComponent);
                combinedPanel.child((Component)itemPanel);
            } else {
                titlePanel.positioning(Positioning.layout());
            }
        } else {
            titlePanel.positioning(Positioning.layout());
        }
        ScalableLabelComponent titleLabel = new ScalableLabelComponent((class_2561)class_2561.method_43470((String)title).method_27692(class_124.field_1063), linkHandler);
        titleLabel.scale = 2.0f;
        titlePanel.child((Component)titleLabel);
        FlowLayout spacedPanel = Containers.horizontalFlow((Sizing)Sizing.fill(), (Sizing)Sizing.content());
        spacedPanel.child((Component)Containers.horizontalFlow((Sizing)Sizing.fill((int)15), (Sizing)Sizing.fixed((int)15)));
        spacedPanel.child((Component)combinedPanel);
        spacedPanel.margins(Insets.of((int)15, (int)5, (int)2, (int)2));
        return spacedPanel;
    }

    public static Map<String, String> parseFrontmatter(String markdownContent) {
        int endDelimiterIndexAlt;
        HashMap<String, String> frontmatter = new HashMap<String, String>();
        if (!markdownContent.startsWith("---")) {
            return frontmatter;
        }
        int endDelimiterIndex = markdownContent.indexOf("---\n", 3);
        int usedDelimitedIndex = Math.max(endDelimiterIndex, endDelimiterIndexAlt = markdownContent.indexOf("---\r\n", 3));
        if (usedDelimitedIndex == -1) {
            return frontmatter;
        }
        String frontmatterContent = markdownContent.substring(4, usedDelimitedIndex);
        List<String> lines = frontmatterContent.lines().toList();
        for (String line : lines) {
            String[] parts = line.split(":", 2);
            if (parts.length != 2) continue;
            String key = parts[0].trim();
            String value = parts[1].trim();
            frontmatter.put(key, value);
        }
        return frontmatter;
    }

    public static String removeFrontmatter(String markdownContent) {
        int endDelimiterIndexAlt;
        if (!markdownContent.startsWith("---")) {
            return markdownContent;
        }
        int endDelimiterIndex = markdownContent.indexOf("---\n", 3);
        int usedDelimitedIndex = Math.max(endDelimiterIndex, endDelimiterIndexAlt = markdownContent.indexOf("---\r\n", 3));
        if (usedDelimitedIndex == -1) {
            return markdownContent;
        }
        return markdownContent.substring(usedDelimitedIndex + 4);
    }

    private static List<String> splitIntoParagraphs(String markdownContent) {
        List<String> lines = markdownContent.lines().toList();
        ArrayList<String> paragraphList = new ArrayList<String>();
        StringBuilder currentParagraph = new StringBuilder();
        boolean inCodeBlock = false;
        for (String s : lines) {
            String line = s.trim();
            boolean isSkipped = Arrays.stream(removedLines).anyMatch(line::startsWith);
            boolean isSkippedDiv = line.startsWith("<div onlineOnly=\"true\"");
            if (isSkipped && !inCodeBlock && !isSkippedDiv) continue;
            boolean newCodeBlock = line.startsWith("```");
            if (inCodeBlock && newCodeBlock) {
                inCodeBlock = false;
            } else if (newCodeBlock) {
                inCodeBlock = true;
                paragraphList.add(currentParagraph.toString());
                currentParagraph = new StringBuilder();
            }
            boolean isHeading = line.startsWith("#");
            boolean isListing = line.matches("[0-9]+\\.\\s.+");
            boolean isUnorderedList = line.matches("-\\s.+");
            boolean isWeirdList = line.matches("\u2022\\s.+");
            boolean isHtml = line.matches("<[a-zA-Z]+");
            if (isHeading || isListing || isUnorderedList || isWeirdList || isHtml) {
                paragraphList.add(currentParagraph.toString());
                currentParagraph = new StringBuilder();
                if (isHeading) {
                    paragraphList.add(line);
                    continue;
                }
                currentParagraph.append(line).append(" ");
                continue;
            }
            boolean isSeparator = line.isEmpty();
            if (isSeparator) {
                paragraphList.add(currentParagraph.toString());
                currentParagraph = new StringBuilder();
            } else if (inCodeBlock) {
                currentParagraph.append(line).append("\n");
            } else {
                currentParagraph.append(line).append(" ");
            }
            boolean containsCodeBlock = line.contains("```");
            if (newCodeBlock || !containsCodeBlock) continue;
            inCodeBlock = false;
        }
        if (!currentParagraph.isEmpty() && !currentParagraph.toString().startsWith("<div onlineOnly=\"true\"")) {
            paragraphList.add(currentParagraph.toString());
        }
        return paragraphList;
    }

    private static Component parseImageParagraph(String paragraphString, String bookId, boolean modAsset) {
        String tagName = modAsset ? "ModAsset" : "Asset";
        Document doc = Jsoup.parseBodyFragment((String)paragraphString);
        Element element = doc.selectFirst(tagName);
        if (element != null) {
            class_2960 itemIdCandidate;
            String location = element.attr("location");
            String widthSource = element.attr("width");
            float width = MarkdownParser.convertWidthStringToFloat(widthSource);
            if (width <= 0.0f) {
                width = 0.5f;
            }
            if (class_7923.field_41178.method_10250(itemIdCandidate = class_2960.method_60654((String)location))) {
                if (width == 0.5f) {
                    width = 0.1f;
                }
                ItemComponent imageComponent = Components.item((class_1799)new class_1799((class_1935)class_7923.field_41178.method_10223(itemIdCandidate)));
                imageComponent.setTooltipFromStack(true);
                imageComponent.verticalSizing(Sizing.fixed((int)((int)(width * 100.0f))));
                return imageComponent;
            }
            String imageModId = location.split(":")[0];
            String imageModPath = location.split(":")[1];
            class_2960 searchPath = class_2960.method_60655((String)"oracle_index", (String)("books/" + bookId + "/.assets/" + bookId + "/" + imageModPath + ".png"));
            Optional resource = class_310.method_1551().method_1478().method_14486(searchPath);
            if (resource.isEmpty()) {
                return Components.label((class_2561)class_2561.method_43470((String)("Image not found: " + String.valueOf(searchPath))).method_27692(class_124.field_1061));
            }
            try {
                class_1011 image = class_1011.method_4309((InputStream)((class_3298)resource.get()).method_14482());
                TextureComponent result = Components.texture((class_2960)searchPath, (int)0, (int)0, (int)image.method_4307(), (int)image.method_4323(), (int)image.method_4307(), (int)image.method_4323());
                result.verticalSizing(Sizing.fixed((int)((int)(width * 100.0f))));
                return result;
            }
            catch (IOException e) {
                return Components.label((class_2561)class_2561.method_43470((String)("Image couldn't be read: " + location + "\n" + e.getMessage().formatted(class_124.field_1061))));
            }
        }
        return Components.label((class_2561)class_2561.method_43470((String)("Image path couldn't be parsed in: " + paragraphString)).method_27692(class_124.field_1061));
    }

    private static Component parseCalloutParagraph(String paragraphString, Predicate<String> linkHandler) {
        Document doc = Jsoup.parseBodyFragment((String)paragraphString);
        Element element = doc.selectFirst("Callout");
        if (element == null) {
            return Components.label((class_2561)class_2561.method_43470((String)"Invalid Callout"));
        }
        String calloutText = element.text();
        String calloutVariant = element.attr("variant");
        Component contentLabel = MarkdownParser.parseParagraphToLabel(calloutText, linkHandler);
        contentLabel.horizontalSizing(Sizing.fill((int)70));
        if (contentLabel instanceof LabelComponent) {
            LabelComponent labelComponent = (LabelComponent)contentLabel;
            labelComponent.horizontalTextAlignment(HorizontalAlignment.CENTER);
            labelComponent.color(Color.ofRgb((int)0x555555));
        }
        LabelComponent titleLabel = Components.label((class_2561)class_2561.method_43470((String)StringUtils.capitalize((String)calloutVariant)));
        FlowLayout contentContainer = Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content());
        contentContainer.padding(Insets.of((int)6, (int)8, (int)8, (int)8));
        contentContainer.margins(Insets.of((int)15, (int)0, (int)10, (int)0));
        contentContainer.surface(ORACLE_PANEL);
        contentContainer.child(contentLabel);
        FlowLayout titleContainer = Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content());
        titleContainer.padding(Insets.of((int)6, (int)5, (int)8, (int)6));
        titleContainer.positioning(Positioning.absolute((int)0, (int)0));
        titleContainer.surface(ORACLE_PANEL_PRESSED);
        titleContainer.child((Component)titleLabel);
        FlowLayout combinedContainer = Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content());
        combinedContainer.child((Component)contentContainer);
        combinedContainer.child((Component)titleContainer);
        return combinedContainer;
    }

    private static Component parseRecipeParagraph(String paragraph) {
        Document doc = Jsoup.parseBodyFragment((String)paragraph.replace("{[", "\"{[").replace("]}", "]}\""));
        Element element = doc.selectFirst("CraftingRecipe");
        if (element == null) {
            return Components.label((class_2561)class_2561.method_43470((String)"Invalid recipe, unable to parse html"));
        }
        String recipeInputs = element.attr("slots");
        String recipeResult = element.attr("result");
        String recipeResultCount = element.attr("count").replace("{", "").replace("}", "");
        int resultCount = 1;
        try {
            resultCount = Integer.parseInt(recipeResultCount);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        List<String> recipeInputItems = MarkdownParser.extractRecipeInputs(recipeInputs);
        if (recipeInputItems.size() != 9) {
            return Components.label((class_2561)class_2561.method_43470((String)"Invalid recipe, unable to parse 9 ingredients"));
        }
        FlowLayout panel = Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content());
        panel.surface(ORACLE_PANEL);
        panel.horizontalAlignment(HorizontalAlignment.CENTER);
        panel.verticalAlignment(VerticalAlignment.CENTER);
        GridLayout inputGrid = Containers.grid((Sizing)Sizing.content(), (Sizing)Sizing.content(), (int)3, (int)3);
        inputGrid.padding(Insets.of((int)3));
        inputGrid.margins(Insets.of((int)3));
        GridLayout backgroundGrid = Containers.grid((Sizing)Sizing.content(), (Sizing)Sizing.content(), (int)3, (int)3);
        backgroundGrid.padding(Insets.of((int)3));
        backgroundGrid.margins(Insets.of((int)3));
        backgroundGrid.positioning(Positioning.relative((int)0, (int)0));
        for (int i = 0; i < recipeInputItems.size(); ++i) {
            String input = recipeInputItems.get(i);
            class_2960 id = class_2960.method_60654((String)input);
            class_1799 itemstack = new class_1799((class_1935)class_7923.field_41178.method_10223(id));
            ItemComponent itemComponent = Components.item((class_1799)itemstack);
            itemComponent.setTooltipFromStack(true);
            int row = i % 3;
            int column = i / 3;
            backgroundGrid.child(MarkdownParser.getItemFrame(), column, row);
            inputGrid.child((Component)itemComponent, column, row);
        }
        TextureComponent arrow = Components.texture((class_2960)class_2960.method_60655((String)"oracle_index", (String)"textures/arrow_empty.png"), (int)0, (int)0, (int)29, (int)16, (int)29, (int)16);
        arrow.margins(Insets.of((int)5));
        ItemComponent result = Components.item((class_1799)new class_1799((class_1935)class_7923.field_41178.method_10223(class_2960.method_60654((String)recipeResult)), resultCount));
        result.setTooltipFromStack(true);
        result.margins(Insets.of((int)5));
        Component resultFrame = MarkdownParser.getItemFrame().positioning(Positioning.relative((int)100, (int)50));
        resultFrame.margins(Insets.of((int)5));
        panel.child((Component)backgroundGrid);
        panel.child((Component)inputGrid);
        panel.child((Component)arrow);
        panel.child((Component)result);
        panel.child(resultFrame);
        return panel;
    }

    public static List<String> extractRecipeInputs(String input) {
        String[] elements;
        ArrayList<String> resultList = new ArrayList<String>();
        String trimmedInput = input.trim();
        if (!trimmedInput.startsWith("{[") || !trimmedInput.endsWith("]}")) {
            System.err.println("Input string does not have the expected format.");
            return resultList;
        }
        trimmedInput = trimmedInput.substring(2, trimmedInput.length() - 2).trim();
        for (String element : elements = trimmedInput.split(",")) {
            String trimmedElement = element.trim();
            if (trimmedElement.startsWith("'") && trimmedElement.endsWith("'")) {
                trimmedElement = trimmedElement.substring(1, trimmedElement.length() - 1);
            }
            resultList.add(trimmedElement);
        }
        return resultList;
    }

    public static Component getItemFrame() {
        return Components.texture((class_2960)ITEM_SLOT, (int)0, (int)0, (int)16, (int)16, (int)16, (int)16).sizing(Sizing.fixed((int)16));
    }

    private static Component parseParagraphToLabel(String paragraphString, Predicate<String> linkHandler) {
        Pattern headingPattern;
        Matcher headingMatcher;
        int headingLevel;
        class_5250 paragraphText = class_2561.method_43473();
        int index = 0;
        String processedParagraphString = paragraphString;
        boolean isCodeBlock = paragraphString.startsWith("```");
        if (isCodeBlock) {
            processedParagraphString = processedParagraphString.replace("```", "").trim();
        }
        if ((headingLevel = MarkdownParser.getHeadingLevel(paragraphString)) > 0 && !isCodeBlock && (headingMatcher = (headingPattern = Pattern.compile("^(#+)\\s*(.+)")).matcher(paragraphString)).find()) {
            processedParagraphString = headingMatcher.group(2).trim();
        }
        while (index < processedParagraphString.length()) {
            Matcher linkMatcher = Pattern.compile("\\[([^]]+)]\\(([^)]+)\\)").matcher(processedParagraphString);
            if (linkMatcher.find(index) && linkMatcher.start() == index && !isCodeBlock) {
                String linkText = linkMatcher.group(1);
                String url = linkMatcher.group(2);
                class_2583 linkStyle = class_2583.field_24360.method_30938(Boolean.valueOf(true)).method_10958(new class_2558(class_2558.class_2559.field_11749, url));
                paragraphText.method_10852((class_2561)class_2561.method_43470((String)linkText).method_10862(linkStyle));
                index += linkMatcher.group(0).length();
                continue;
            }
            Matcher boldMatcher = Pattern.compile("\\*\\*([^*]+)\\*\\*|__([^_]+)__").matcher(processedParagraphString);
            if (boldMatcher.find(index) && boldMatcher.start() == index && !isCodeBlock) {
                String boldText = boldMatcher.group(1) != null ? boldMatcher.group(1) : boldMatcher.group(2);
                paragraphText.method_10852((class_2561)class_2561.method_43470((String)boldText).method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true))));
                index += boldMatcher.group(0).length();
                continue;
            }
            Matcher italicMatcher = Pattern.compile("\\*([^*]+)\\*|_([^_]+)_").matcher(processedParagraphString);
            if (italicMatcher.find(index) && italicMatcher.start() == index && !isCodeBlock) {
                String italicText = italicMatcher.group(1) != null ? italicMatcher.group(1) : italicMatcher.group(2);
                paragraphText.method_10852((class_2561)class_2561.method_43470((String)italicText).method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(true))));
                index += italicMatcher.group(0).length();
                continue;
            }
            Matcher colorMatcher = Pattern.compile("#([0-9A-Fa-f]{6})\\s*([^#]+?)\\s*#([0-9A-Fa-f]{6})").matcher(processedParagraphString);
            if (colorMatcher.find(index) && colorMatcher.start() == index && !isCodeBlock) {
                String color1 = colorMatcher.group(1);
                String coloredText = colorMatcher.group(2);
                class_5251 textColor1 = class_5251.method_27717((int)Integer.parseInt(color1, 16));
                class_5250 coloredTextComponent = class_2561.method_43470((String)coloredText).method_10862(class_2583.field_24360.method_27703(textColor1));
                paragraphText.method_10852((class_2561)coloredTextComponent);
                index += colorMatcher.group(0).length();
                continue;
            }
            paragraphText.method_10852((class_2561)class_2561.method_43470((String)String.valueOf(processedParagraphString.charAt(index))));
            ++index;
        }
        if (headingLevel > 0) {
            paragraphText = paragraphText.method_27692(class_124.field_1080);
        }
        ScalableLabelComponent label = new ScalableLabelComponent((class_2561)paragraphText, linkHandler);
        if (headingLevel > 0) {
            label.scale = 1.5f - (float)headingLevel * 0.1f;
        }
        label.lineHeight(10);
        if (isCodeBlock) {
            FlowLayout panel = Containers.horizontalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content());
            panel.surface(ORACLE_PANEL_DARK);
            panel.padding(Insets.of((int)6));
            panel.child((Component)label);
            label.horizontalSizing(Sizing.fill((int)100));
            return panel;
        }
        return label;
    }

    public static int getHeadingLevel(String paragraphString) {
        Matcher headingMatcher = Pattern.compile("^(#+)\\s*(.+)").matcher(paragraphString.trim());
        if (headingMatcher.find()) {
            return headingMatcher.group(1).length();
        }
        return 0;
    }

    public static float convertWidthStringToFloat(String input) {
        if (input == null || input.isEmpty()) {
            return 0.0f;
        }
        String trimmedInput = input.trim();
        if (trimmedInput.endsWith("%")) {
            try {
                String percentageString = trimmedInput.substring(0, trimmedInput.length() - 1);
                int percentage = Integer.parseInt(percentageString);
                return (float)percentage / 100.0f;
            }
            catch (NumberFormatException e) {
                System.err.println("Error parsing percentage value: " + input);
                return 0.0f;
            }
        }
        if (trimmedInput.startsWith("{") && trimmedInput.endsWith("}")) {
            try {
                String numberString = trimmedInput.substring(1, trimmedInput.length() - 1);
                int number = Integer.parseInt(numberString);
                return (float)number / 1000.0f;
            }
            catch (NumberFormatException e) {
                System.err.println("Error parsing braced number value: " + input);
                return 0.0f;
            }
        }
        System.err.println("Invalid input format: " + input);
        return 0.0f;
    }
}

